function [residual, g1, g2] = BGG_financial_3_p45_phi2_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                     columns: variables in declaration order
%                                                     rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 66, 1);

%
% Model equations
%

g__ = params(14)/100;
betta__ = (1+params(13)/100)/(1+params(15)/100)/(1+g__)^(-params(6));
LAMBDA_LEAD__ = (1+g__)^(-params(6))*betta__*y(12)/y(12);
mupsi__ = (-0.5)*y(57)^2;
T41 = (1+g__)^(1-params(6));
T42 = betta__*T41;
T65 = y(4)-y(4)*params(7)/(1+g__);
T67 = T65^(1-params(6))/(1-params(6));
T75 = exp((params(6)-1)*y(5)^(1+params(33))/(1+params(33)));
T157 = 1/(1-1/params(5));
T166 = y(20)^params(5);
T169 = y(19)^(params(5)*params(12));
T170 = T166/T169;
T180 = y(19)*y(19)^(params(12)*(params(5)-1));
T191 = y(19)^params(12)/y(20);
T213 = y(6)/(1+g__);
T215 = T213^(1-params(2));
T234 = 1/(1-1/params(4));
T236 = T234*y(33);
T246 = y(19)^(params(4)*params(11));
T247 = y(19)^params(4)/T246;
T256 = y(19)^(params(11)*(params(4)-1));
T258 = LAMBDA_LEAD__*(1+g__)*params(9)*y(19)^(params(4)-1)/T256;
T266 = y(19)^params(11)/y(19);
TEF_1 = logncdf(y(44),mupsi__,y(57));
T383 = TEF_1;
T388 = log(y(44))/y(57)-y(57)/2;
T403 = 2*y(57)^2;
T405 = exp((-((mupsi__+log(y(44)))^2))/T403);
T589 = 1/y(10)-1/(y(10));
T611 = 1/y(15)-1/(y(15));
T651 = ((y(18))-y(18))/((y(18))*(y(18)))/(y(18)/(y(18)));
T663 = (-(T166*getPowerDeriv(y(19),params(5)*params(12),1)))/(T169*T169);
T692 = (T246*getPowerDeriv(y(19),params(4),1)-y(19)^params(4)*getPowerDeriv(y(19),params(4)*params(11),1))/(T246*T246);
T728 = getPowerDeriv(y(20),params(5),1)/T169;
T772 = 1/y(24)-1/(y(24));
T797 = 1/y(29)-1/(y(29));
T825 = 1/y(34)-1/(y(34));
T844 = 1/y(38)-1/(y(38));
T849 = 1/y(39)-1/(y(39));
TEFD_fdd_1_1 = jacob_element('logncdf',1,{y(44),mupsi__,y(57)});
T872 = TEFD_fdd_1_1;
TEFD_fdd_1_2 = jacob_element('logncdf',2,{y(44),mupsi__,y(57)});
T873 = TEFD_fdd_1_2;
TEFD_fdd_1_3 = jacob_element('logncdf',3,{y(44),mupsi__,y(57)});
T874 = TEFD_fdd_1_3;
T883 = exp((-(T388*T388))/2)/2.506628274631;
T913 = ((y(51)-y(56)*y(50))*y(52)+(1-y(51))*(y(52)-y(56)*y(53)))*((y(51)-y(56)*y(50))*y(52)+(1-y(51))*(y(52)-y(56)*y(53)));
lhs =y(42);
rhs =(1.01^(1-params(6))-1)*y(3)+y(42)*T42;
residual(1)= lhs-rhs;
lhs =y(1);
rhs =y(3)+T42*y(1);
residual(2)= lhs-rhs;
lhs =y(2);
rhs =y(3)-params(32)*(y(18)-(y(18)))^2+T42*y(2);
residual(3)= lhs-rhs;
lhs =y(3);
rhs =T67*T75;
residual(4)= lhs-rhs;
lhs =y(6);
rhs =y(6)*(1-params(3))/(1+g__)+(1-y(7))*y(9)*y(10);
residual(5)= lhs-rhs;
lhs =y(8);
rhs =(1+g__)*y(9)/y(9);
residual(6)= lhs-rhs;
lhs =y(7);
rhs =params(8)*(y(8)-1-g__)^2;
residual(7)= lhs-rhs;
lhs =y(11);
rhs =(y(8)-1-g__)*2*params(8);
residual(8)= lhs-rhs;
lhs =y(12);
rhs =(1-params(6))*y(3)/T65-y(3)*(1-params(6))*betta__*params(7)/T41/((1+g__)*y(4)-y(4)*params(7));
residual(9)= lhs-rhs;
lhs =y(13);
rhs =(-y(66))/y(12);
residual(10)= lhs-rhs;
lhs =1;
rhs =y(15)*y(16)*LAMBDA_LEAD__;
residual(11)= lhs-rhs;
lhs =1;
rhs =y(10)*y(17)*(1-y(7)-y(8)*y(11))+y(10)*y(11)*LAMBDA_LEAD__*y(17)*y(8)^2;
residual(12)= lhs-rhs;
lhs =y(16);
rhs =y(18)/y(19);
residual(13)= lhs-rhs;
lhs =y(66);
rhs =y(3)*(-(1-params(6)))*y(5)^params(33);
residual(14)= lhs-rhs;
lhs =y(20);
rhs =y(19)*(1+g__)*y(21)/y(21);
residual(15)= lhs-rhs;
lhs =y(22);
rhs =y(13)*T157*y(23)*y(24)+y(22)*LAMBDA_LEAD__*(1+g__)*params(10)*T170;
residual(16)= lhs-rhs;
lhs =y(25);
rhs =y(23)+y(25)*LAMBDA_LEAD__*params(10)*T166/T180;
residual(17)= lhs-rhs;
lhs =y(26);
rhs =y(22)/(y(21)*y(25));
residual(18)= lhs-rhs;
lhs =1;
rhs =params(10)*T191^(1-params(5))+(1-params(10))*y(26)^(1-params(5));
residual(19)= lhs-rhs;
lhs =y(27);
rhs =y(27)*params(10)*T170+(1-params(10))*y(26)^(-params(5));
residual(20)= lhs-rhs;
lhs =y(28);
rhs =(y(23)*y(29))^params(2)*T215;
residual(21)= lhs-rhs;
lhs =y(21);
rhs =y(28)*params(2)*y(30)/y(23);
residual(22)= lhs-rhs;
lhs =y(14);
rhs =y(28)*(1-params(2))*y(30)/T213;
residual(23)= lhs-rhs;
lhs =y(31);
rhs =y(30);
residual(24)= lhs-rhs;
lhs =y(32);
rhs =y(31)*T236*y(34)+y(32)*LAMBDA_LEAD__*(1+g__)*params(9)*T247;
residual(25)= lhs-rhs;
lhs =y(35);
rhs =y(33)+y(35)*T258;
residual(26)= lhs-rhs;
lhs =y(36);
rhs =y(32)/y(35);
residual(27)= lhs-rhs;
lhs =1;
rhs =params(9)*T266^(1-params(4))+(1-params(9))*y(36)^(1-params(4));
residual(28)= lhs-rhs;
lhs =y(37);
rhs =y(37)*params(9)*T247+(1-params(9))*y(36)^(-params(4));
residual(29)= lhs-rhs;
lhs =log(y(18)/(y(18)));
rhs =log(y(18)/(y(18)))*params(16)+(1-params(16))*(params(17)*log(y(19)/(y(19)))+params(18)*log(y(33)/(y(33))))+log(y(38));
residual(30)= lhs-rhs;
lhs =y(5);
rhs =y(23)*y(27);
residual(31)= lhs-rhs;
lhs =y(28);
rhs =y(33)*y(37);
residual(32)= lhs-rhs;
lhs =y(40);
rhs =(y(14)+(1-params(3))*y(17))/y(17);
residual(33)= lhs-rhs;
lhs =y(41);
rhs =y(40)-y(16);
residual(34)= lhs-rhs;
lhs =y(40);
rhs =y(16)*y(43);
residual(35)= lhs-rhs;
lhs =y(45);
rhs =y(6)*y(17)*y(40)*(y(54)+y(55))*(1-y(51))/(1+g__);
residual(36)= lhs-rhs;
lhs =y(16)*(y(6)*y(17)-y(45));
rhs =y(6)*y(17)*y(40)*(y(51)-y(56)*y(50));
residual(37)= lhs-rhs;
lhs =y(43);
rhs =y(52)/((y(51)-y(56)*y(50))*y(52)+(1-y(51))*(y(52)-y(56)*y(53)));
residual(38)= lhs-rhs;
lhs =y(33);
rhs =y(9)+y(4)+y(46)+y(39)+y(6)*y(17)*y(40)*y(56)*y(50)/(1+g__);
residual(39)= lhs-rhs;
lhs =y(46);
rhs =y(6)*y(17)*y(40)*(1-y(51))*(1-y(54))*(1-y(55))/(1+g__);
residual(40)= lhs-rhs;
lhs =y(47);
rhs =y(6)*y(17)-y(45);
residual(41)= lhs-rhs;
lhs =y(44);
rhs =y(47)*y(48)/(y(6)*y(17)*y(40))/y(19);
residual(42)= lhs-rhs;
lhs =y(49);
rhs =T383;
residual(43)= lhs-rhs;
lhs =y(50);
rhs =normcdf(T388,0,1);
residual(44)= lhs-rhs;
lhs =y(51);
rhs =y(50)+y(44)*(1-y(49));
residual(45)= lhs-rhs;
lhs =y(52);
rhs =1-y(49);
residual(46)= lhs-rhs;
lhs =y(53);
rhs =1/(y(57)*y(44)*2.506628274631)*T405;
residual(47)= lhs-rhs;
lhs =log(y(29))-log((y(29)));
rhs =(log(y(29))-log((y(29))))*params(20)+x(1);
residual(48)= lhs-rhs;
lhs =log(y(39))-log((y(39)));
rhs =(log(y(39))-log((y(39))))*params(21)+x(2);
residual(49)= lhs-rhs;
lhs =log(y(34))-log((y(34)));
rhs =(log(y(34))-log((y(34))))*params(22)+x(3);
residual(50)= lhs-rhs;
lhs =log(y(24))-log((y(24)));
rhs =(log(y(24))-log((y(24))))*params(23)+x(6);
residual(51)= lhs-rhs;
lhs =log(y(10))-log((y(10)));
rhs =(log(y(10))-log((y(10))))*params(26)+x(5);
residual(52)= lhs-rhs;
lhs =log(y(38))-log((y(38)));
rhs =(log(y(38))-log((y(38))))*params(24)+x(4);
residual(53)= lhs-rhs;
lhs =log(y(15))-log((y(15)));
rhs =(log(y(15))-log((y(15))))*params(25)+x(7);
residual(54)= lhs-rhs;
lhs =y(58);
rhs =log(1+g__);
residual(55)= lhs-rhs;
lhs =y(59);
rhs =log(1+g__);
residual(56)= lhs-rhs;
lhs =y(64);
rhs =log(1+g__);
residual(57)= lhs-rhs;
lhs =y(65);
rhs =log(1+g__);
residual(58)= lhs-rhs;
lhs =y(62);
rhs =(y(23)-(y(23)))/(y(23));
residual(59)= lhs-rhs;
lhs =y(61);
rhs =y(18)-1;
residual(60)= lhs-rhs;
lhs =y(60);
rhs =log(y(19));
residual(61)= lhs-rhs;
lhs =y(63);
rhs =y(41);
residual(62)= lhs-rhs;
lhs =y(54);
rhs =0.99;
residual(63)= lhs-rhs;
lhs =y(55);
rhs =(y(55));
residual(64)= lhs-rhs;
lhs =y(56);
rhs =(y(56));
residual(65)= lhs-rhs;
lhs =y(57);
rhs =(y(57));
residual(66)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(66, 66);

  %
  % Jacobian matrix
  %

  g1(1,3)=(-(1.01^(1-params(6))-1));
  g1(1,42)=1-T42;
  g1(2,1)=1-T42;
  g1(2,3)=(-1);
  g1(3,2)=1-T42;
  g1(3,3)=(-1);
  g1(4,3)=1;
  g1(4,4)=(-(T75*(1-params(7)/(1+g__))*getPowerDeriv(T65,1-params(6),1)/(1-params(6))));
  g1(4,5)=(-(T67*T75*(params(6)-1)*getPowerDeriv(y(5),1+params(33),1)/(1+params(33))));
  g1(5,6)=1-(1-params(3))/(1+g__);
  g1(5,7)=(-(y(10)*(-y(9))));
  g1(5,9)=(-((1-y(7))*y(10)));
  g1(5,10)=(-((1-y(7))*y(9)));
  g1(6,8)=1;
  g1(7,7)=1;
  g1(7,8)=(-(params(8)*2*(y(8)-1-g__)));
  g1(8,8)=(-(2*params(8)));
  g1(8,11)=1;
  g1(9,3)=(-((1-params(6))/T65-(1-params(6))*betta__*params(7)/T41/((1+g__)*y(4)-y(4)*params(7))));
  g1(9,4)=(-((-((1-params(6))*y(3)*(1-params(7)/(1+g__))))/(T65*T65)-(-(y(3)*(1-params(6))*betta__*params(7)/T41*(1+g__-params(7))))/(((1+g__)*y(4)-y(4)*params(7))*((1+g__)*y(4)-y(4)*params(7)))));
  g1(9,12)=1;
  g1(10,12)=(-(y(66)/(y(12)*y(12))));
  g1(10,13)=1;
  g1(10,66)=(-((-1)/y(12)));
  g1(11,15)=(-(y(16)*LAMBDA_LEAD__));
  g1(11,16)=(-(y(15)*LAMBDA_LEAD__));
  g1(12,7)=(-(y(10)*(-y(17))));
  g1(12,8)=(-(y(10)*y(17)*(-y(11))+y(10)*y(11)*LAMBDA_LEAD__*y(17)*2*y(8)));
  g1(12,10)=(-(y(17)*(1-y(7)-y(8)*y(11))+y(11)*LAMBDA_LEAD__*y(17)*y(8)^2));
  g1(12,11)=(-(y(10)*y(17)*(-y(8))+y(10)*LAMBDA_LEAD__*y(17)*y(8)^2));
  g1(12,17)=(-(y(10)*(1-y(7)-y(8)*y(11))+y(10)*y(8)^2*y(11)*LAMBDA_LEAD__));
  g1(13,16)=1;
  g1(13,18)=(-(1/y(19)));
  g1(13,19)=(-((-y(18))/(y(19)*y(19))));
  g1(14,3)=(-((-(1-params(6)))*y(5)^params(33)));
  g1(14,5)=(-(y(3)*(-(1-params(6)))*getPowerDeriv(y(5),params(33),1)));
  g1(14,66)=1;
  g1(15,19)=(-((1+g__)*y(21)/y(21)));
  g1(15,20)=1;
  g1(16,13)=(-(y(24)*T157*y(23)));
  g1(16,19)=(-(y(22)*LAMBDA_LEAD__*(1+g__)*params(10)*T663));
  g1(16,20)=(-(y(22)*LAMBDA_LEAD__*(1+g__)*params(10)*T728));
  g1(16,22)=1-LAMBDA_LEAD__*(1+g__)*params(10)*T170;
  g1(16,23)=(-(y(13)*T157*y(24)));
  g1(16,24)=(-(y(13)*T157*y(23)));
  g1(17,19)=(-(y(25)*LAMBDA_LEAD__*params(10)*(-(T166*(y(19)^(params(12)*(params(5)-1))+y(19)*getPowerDeriv(y(19),params(12)*(params(5)-1),1))))/(T180*T180)));
  g1(17,20)=(-(y(25)*LAMBDA_LEAD__*params(10)*getPowerDeriv(y(20),params(5),1)/T180));
  g1(17,23)=(-1);
  g1(17,25)=1-LAMBDA_LEAD__*params(10)*T166/T180;
  g1(18,21)=(-((-(y(22)*y(25)))/(y(21)*y(25)*y(21)*y(25))));
  g1(18,22)=(-(1/(y(21)*y(25))));
  g1(18,25)=(-((-(y(21)*y(22)))/(y(21)*y(25)*y(21)*y(25))));
  g1(18,26)=1;
  g1(19,19)=(-(params(10)*getPowerDeriv(y(19),params(12),1)/y(20)*getPowerDeriv(T191,1-params(5),1)));
  g1(19,20)=(-(params(10)*getPowerDeriv(T191,1-params(5),1)*(-(y(19)^params(12)))/(y(20)*y(20))));
  g1(19,26)=(-((1-params(10))*getPowerDeriv(y(26),1-params(5),1)));
  g1(20,19)=(-(y(27)*params(10)*T663));
  g1(20,20)=(-(y(27)*params(10)*T728));
  g1(20,26)=(-((1-params(10))*getPowerDeriv(y(26),(-params(5)),1)));
  g1(20,27)=1-params(10)*T170;
  g1(21,6)=(-((y(23)*y(29))^params(2)*1/(1+g__)*getPowerDeriv(T213,1-params(2),1)));
  g1(21,23)=(-(T215*y(29)*getPowerDeriv(y(23)*y(29),params(2),1)));
  g1(21,28)=1;
  g1(21,29)=(-(T215*y(23)*getPowerDeriv(y(23)*y(29),params(2),1)));
  g1(22,21)=1;
  g1(22,23)=(-((-(y(28)*params(2)*y(30)))/(y(23)*y(23))));
  g1(22,28)=(-(params(2)*y(30)/y(23)));
  g1(22,30)=(-(y(28)*params(2)/y(23)));
  g1(23,6)=(-((-(y(28)*(1-params(2))*y(30)*1/(1+g__)))/(T213*T213)));
  g1(23,14)=1;
  g1(23,28)=(-((1-params(2))*y(30)/T213));
  g1(23,30)=(-(y(28)*(1-params(2))/T213));
  g1(24,30)=(-1);
  g1(24,31)=1;
  g1(25,19)=(-(y(32)*LAMBDA_LEAD__*(1+g__)*params(9)*T692));
  g1(25,31)=(-(T236*y(34)));
  g1(25,32)=1-LAMBDA_LEAD__*(1+g__)*params(9)*T247;
  g1(25,33)=(-(y(34)*y(31)*T234));
  g1(25,34)=(-(y(31)*T236));
  g1(26,19)=(-(y(35)*LAMBDA_LEAD__*(1+g__)*params(9)*(T256*getPowerDeriv(y(19),params(4)-1,1)-y(19)^(params(4)-1)*getPowerDeriv(y(19),params(11)*(params(4)-1),1))/(T256*T256)));
  g1(26,33)=(-1);
  g1(26,35)=1-T258;
  g1(27,32)=(-(1/y(35)));
  g1(27,35)=(-((-y(32))/(y(35)*y(35))));
  g1(27,36)=1;
  g1(28,19)=(-(params(9)*(y(19)*getPowerDeriv(y(19),params(11),1)-y(19)^params(11))/(y(19)*y(19))*getPowerDeriv(T266,1-params(4),1)));
  g1(28,36)=(-((1-params(9))*getPowerDeriv(y(36),1-params(4),1)));
  g1(29,19)=(-(y(37)*params(9)*T692));
  g1(29,36)=(-((1-params(9))*getPowerDeriv(y(36),(-params(4)),1)));
  g1(29,37)=1-params(9)*T247;
  g1(30,18)=T651-params(16)*T651;
  g1(30,19)=(-((1-params(16))*params(17)*((y(19))-y(19))/((y(19))*(y(19)))/(y(19)/(y(19)))));
  g1(30,33)=(-((1-params(16))*params(18)*((y(33))-y(33))/((y(33))*(y(33)))/(y(33)/(y(33)))));
  g1(30,38)=(-(1/y(38)));
  g1(31,5)=1;
  g1(31,23)=(-y(27));
  g1(31,27)=(-y(23));
  g1(32,28)=1;
  g1(32,33)=(-y(37));
  g1(32,37)=(-y(33));
  g1(33,14)=(-(1/y(17)));
  g1(33,17)=(-(((1-params(3))*y(17)-(y(14)+(1-params(3))*y(17)))/(y(17)*y(17))));
  g1(33,40)=1;
  g1(34,16)=1;
  g1(34,40)=(-1);
  g1(34,41)=1;
  g1(35,16)=(-y(43));
  g1(35,40)=1;
  g1(35,43)=(-y(16));
  g1(36,6)=(-(y(17)*y(40)*(y(54)+y(55))*(1-y(51))/(1+g__)));
  g1(36,17)=(-(y(6)*y(40)*(y(54)+y(55))*(1-y(51))/(1+g__)));
  g1(36,40)=(-(y(6)*y(17)*(y(54)+y(55))*(1-y(51))/(1+g__)));
  g1(36,45)=1;
  g1(36,51)=(-(y(6)*y(17)*y(40)*(-(y(54)+y(55)))/(1+g__)));
  g1(36,54)=(-(y(6)*y(17)*y(40)*(1-y(51))/(1+g__)));
  g1(36,55)=(-(y(6)*y(17)*y(40)*(1-y(51))/(1+g__)));
  g1(37,6)=y(16)*y(17)-y(17)*y(40)*(y(51)-y(56)*y(50));
  g1(37,16)=y(6)*y(17)-y(45);
  g1(37,17)=y(6)*y(16)-(y(51)-y(56)*y(50))*y(6)*y(40);
  g1(37,40)=(-(y(6)*y(17)*(y(51)-y(56)*y(50))));
  g1(37,45)=(-y(16));
  g1(37,50)=(-(y(6)*y(17)*y(40)*(-y(56))));
  g1(37,51)=(-(y(6)*y(17)*y(40)));
  g1(37,56)=(-(y(6)*y(17)*y(40)*(-y(50))));
  g1(38,43)=1;
  g1(38,50)=(-((-(y(52)*y(52)*(-y(56))))/T913));
  g1(38,51)=(-((-(y(52)*(y(52)-(y(52)-y(56)*y(53)))))/T913));
  g1(38,52)=(-(((y(51)-y(56)*y(50))*y(52)+(1-y(51))*(y(52)-y(56)*y(53))-y(52)*(1-y(51)+y(51)-y(56)*y(50)))/T913));
  g1(38,53)=(-((-(y(52)*(1-y(51))*(-y(56))))/T913));
  g1(38,56)=(-((-(y(52)*(y(52)*(-y(50))+(1-y(51))*(-y(53)))))/T913));
  g1(39,4)=(-1);
  g1(39,6)=(-(y(17)*y(40)*y(56)*y(50)/(1+g__)));
  g1(39,9)=(-1);
  g1(39,17)=(-(y(6)*y(40)*y(56)*y(50)/(1+g__)));
  g1(39,33)=1;
  g1(39,39)=(-1);
  g1(39,40)=(-(y(6)*y(17)*y(56)*y(50)/(1+g__)));
  g1(39,46)=(-1);
  g1(39,50)=(-(y(6)*y(17)*y(40)*y(56)/(1+g__)));
  g1(39,56)=(-(y(6)*y(17)*y(40)*y(50)/(1+g__)));
  g1(40,6)=(-(y(17)*y(40)*(1-y(51))*(1-y(54))*(1-y(55))/(1+g__)));
  g1(40,17)=(-(y(6)*y(40)*(1-y(51))*(1-y(54))*(1-y(55))/(1+g__)));
  g1(40,40)=(-(y(6)*y(17)*(1-y(51))*(1-y(54))*(1-y(55))/(1+g__)));
  g1(40,46)=1;
  g1(40,51)=(-(y(6)*y(17)*y(40)*(-((1-y(54))*(1-y(55))))/(1+g__)));
  g1(40,54)=(-(y(6)*y(17)*y(40)*(1-y(51))*(-(1-y(55)))/(1+g__)));
  g1(40,55)=(-(y(6)*y(17)*y(40)*(1-y(51))*(-(1-y(54)))/(1+g__)));
  g1(41,6)=(-y(17));
  g1(41,17)=(-y(6));
  g1(41,45)=1;
  g1(41,47)=1;
  g1(42,6)=(-((-(y(17)*y(40)*y(47)*y(48)))/(y(6)*y(17)*y(40)*y(6)*y(17)*y(40))/y(19)));
  g1(42,17)=(-((-(y(47)*y(48)*y(6)*y(40)))/(y(6)*y(17)*y(40)*y(6)*y(17)*y(40))/y(19)));
  g1(42,19)=(-((-(y(47)*y(48)/(y(6)*y(17)*y(40))))/(y(19)*y(19))));
  g1(42,40)=(-((-(y(6)*y(17)*y(47)*y(48)))/(y(6)*y(17)*y(40)*y(6)*y(17)*y(40))/y(19)));
  g1(42,44)=1;
  g1(42,47)=(-(y(48)/(y(6)*y(17)*y(40))/y(19)));
  g1(42,48)=(-(y(47)/(y(6)*y(17)*y(40))/y(19)));
  g1(43,44)=(-T872);
  g1(43,49)=1;
  g1(43,57)=(-(T874+T873*(-0.5)*2*y(57)));
  g1(44,44)=(-(1/y(44)/y(57)*T883));
  g1(44,50)=1;
  g1(44,57)=(-(T883*((-log(y(44)))/(y(57)*y(57))-0.5)));
  g1(45,44)=(-(1-y(49)));
  g1(45,49)=y(44);
  g1(45,50)=(-1);
  g1(45,51)=1;
  g1(46,49)=1;
  g1(46,52)=1;
  g1(47,44)=(-(T405*(-(y(57)*2.506628274631))/(y(57)*y(44)*2.506628274631*y(57)*y(44)*2.506628274631)+1/(y(57)*y(44)*2.506628274631)*T405*(-(1/y(44)*2*(mupsi__+log(y(44)))))/T403));
  g1(47,53)=1;
  g1(47,57)=(-(T405*(-(y(44)*2.506628274631))/(y(57)*y(44)*2.506628274631*y(57)*y(44)*2.506628274631)+1/(y(57)*y(44)*2.506628274631)*T405*(T403*(-(2*(mupsi__+log(y(44)))*(-0.5)*2*y(57)))-(-((mupsi__+log(y(44)))^2))*2*2*y(57))/(T403*T403)));
  g1(48,29)=T797-params(20)*T797;
  g1(49,39)=T849-params(21)*T849;
  g1(50,34)=T825-params(22)*T825;
  g1(51,24)=T772-params(23)*T772;
  g1(52,10)=T589-params(26)*T589;
  g1(53,38)=T844-params(24)*T844;
  g1(54,15)=T611-params(25)*T611;
  g1(55,58)=1;
  g1(56,59)=1;
  g1(57,64)=1;
  g1(58,65)=1;
  g1(59,23)=(-((-(y(23)-(y(23))))/((y(23))*(y(23)))));
  g1(59,62)=1;
  g1(60,18)=(-1);
  g1(60,61)=1;
  g1(61,19)=(-(1/y(19)));
  g1(61,60)=1;
  g1(62,41)=(-1);
  g1(62,63)=1;
  g1(63,54)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],66,4356);
end
end
